/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.collection;

import icyllis.annotations.NotNull;
import icyllis.annotations.Nullable;
import java.util.function.Function;

public class CopyOnWriteRef<T> {
    @Nullable
    private T value;
    private int referenceCount;
    @NotNull
    private final Function<T, T> copyFunction;

    public CopyOnWriteRef(@Nullable T value, @NotNull Function<T, T> copyFunction) {
        this.value = value;
        this.referenceCount = 0;
        this.copyFunction = copyFunction;
    }

    @Nullable
    public T getPeek() {
        return this.value;
    }

    @Nullable
    public T getImmutable() {
        if (this.value != null) {
            ++this.referenceCount;
        }
        return this.value;
    }

    @Nullable
    public T getMutable() {
        if (this.referenceCount > 0) {
            this.value = this.copyFunction.apply(this.value);
            this.referenceCount = 0;
        }
        return this.value;
    }

    public void setValue(@Nullable T value) {
        this.referenceCount = 0;
        this.value = this.copyFunction.apply(value);
    }

    public boolean isMutable() {
        return this.referenceCount == 0;
    }
}

